import { __ } from "@wordpress/i18n";
const { Button } = wp.components;

const AddProductRow = ({ productTable, handleProductRow }) => {
	return (
		<Button
			isDefault
			className="affx-add-pdt-row-btn components_panel_btn"
			onClick={() => handleProductRow(productTable)}
		>
			<span className="screen-reader-text">
				{__("Add Product Row", "affiliatex")}
			</span>
			<svg
				xmlns="http://www.w3.org/2000/svg"
				viewBox="-2 -2 24 24"
				width="24"
				height="24"
				role="img"
				aria-hidden="true"
				focusable="false"
			>
				<path d="M10 1c-5 0-9 4-9 9s4 9 9 9 9-4 9-9-4-9-9-9zm0 16c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7zm1-11H9v3H6v2h3v3h2v-3h3V9h-3V6zM10 1c-5 0-9 4-9 9s4 9 9 9 9-4 9-9-4-9-9-9zm0 16c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7zm1-11H9v3H6v2h3v3h2v-3h3V9h-3V6z"></path>
			</svg>
		</Button>
	);
};

export default AddProductRow;
